'==========================================================================
'
' NAME: 	LogWriter.vbs
'
' COMMENT: 	This vbscrpt file contains methods To
'			create, open, write to and close a log file
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'==========================================================================


Public Function InitializeLogFile(strScriptPath,strLogName)
'===================================================
'	NAME:	InitializeLogFile
'	IN:		strScriptPath = Full path for the scipts
'	OUT:	Name of log file
'	COMMENT: This procedure opens a log file For
'			writing.
'===================================================
	Dim strDisclaimer
	Dim oLogFile
	Dim oFolder
	Dim strLogPath
	
	'Set Disclaimer Text
	strDisclaimer = "THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL "  & VBCRLF & _
				  "PURPOSES ONLY, AND IS PROVIDED ""AS Is"", WITHOUT WARRANTY OF ANY KIND," & VBCRLF & _ 
				  "EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED " & VBCRLF & _
				  "WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE," & VBCRLF & _
				  "AND MAY NOT BE REDISTRIBUTED IN ANY MANNER."  & VBCRLF & _
				  "Copyright (c) 2006  Microsoft Corporation.  All rights reserved."
	
	strLogPath = strScriptPath & "\Logs"
	'Check to see of 'Logs' folder exists
	If oFSO.FolderExists(strLogPath) = False Then
		'It doesn't so create it
		set oFolder = oFSO.CreateFolder(strLogPath)
	End If
	'Create and Open a File for Writing
	set oLogFile = oFSO.OpenTextFile(strLogPath & "\" & strLogName,8,True)
	oLogFile.WriteLine strLogPath & "\" & strLogName
	oLogFile.WriteLine("#######################################################################")
	oLogFile.WriteBlankLines(1)
	oLogFile.WriteLine(vbTab & strLogName & " initialized at " & Now() & vbCRLF)
	oLogFile.WriteBlankLines(1)
	oLogFile.WriteLine(strDisclaimer)
	oLogFile.WriteLine("#######################################################################")
	Set InitializeLogFile = oLogFile
End Function

Sub Write(oLog,str2Write,strType,vDebug)
'===================================================
'	NAME:	Write
'	IN:		oLog - TextFile object
'			str2Write - String to write tot he log file
'			strType - Type of string
'	COMMENT: This procedure writes inforation to the log
'===================================================


	If vDebug = 1 Then 
		' Write the Message to the screen
		wscript.echo strType & ": " & str2Write
	Else 
		' Write a Progress Dot to the screen
		wscript.stdOut.Write "."
	end If
	' Write the Message to the Logfile and include the Type and 
	' a Timestamp
	oLog.WriteLine Now() & ": " & strType & ": " & str2Write
End Sub


Public Function CreateLogFileName()
	Dim strLogFileName
	strLogFileName = "Log_" & Year(now) & Month(now) & Day(now) & Hour(now) & Minute(now) & Second(now) & ".log"
	CreateLogFileName=strLogFileName

End Function


Public sub Finalize(oLog,tTime)
'===================================================
'	NAME:	Finalize
'	IN:		oLog - TextFile object
'			tTime - Timer number when script started
'	COMMENT: This procedure Closes the log
'===================================================
	Dim tElapse
	tElapse = Mid(CStr(Timer - tTime),1,5)
	Write oLog,"Script complete.",Err_INFO,1
	Write oLog,"It took " & tElapse & " seconds to complete the task(s).",Err_INFO,1
	oLog.close
End Sub
